// $Id: CMenuItem.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMenuItem.hpp"
using Exponent::GUI::Controls::CMenuItem;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMenuItem, CCountedObject);

//	===========================================================================
CMenuItem::CMenuItem(const CString &text, const long identifier, const EMenuItemTypes type, const bool enabled) 
		 : m_normalImage(NULL)
		 , m_rolloverImage(NULL)
		 , m_text(text)
		 , m_id(identifier)
		 , m_index(0)
		 , m_type(type)
		 , m_isEnabled(enabled)
		 , m_textColour(CAlphaColour::CALPHACOLOUR_BLACK)
		 , m_overrideTextColour(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CMenuItem);

	this->setText(text);
	this->setId(identifier);
	this->setType(type);
	this->enable(enabled);
	this->setTextColour(CAlphaColour::CALPHACOLOUR_BLACK);
	this->overrideTextColour(false);

	NULL_POINTER(m_normalImage);	
	NULL_POINTER(m_rolloverImage);	
}

//	===========================================================================
CMenuItem::~CMenuItem()
{
	EXPONENT_CLASS_DESTRUCTION(CMenuItem);
	FORGET_COUNTED_OBJECT(m_normalImage);
	FORGET_COUNTED_OBJECT(m_rolloverImage);
}
